/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.lib.feature;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;

public class SedimentLayerFeature
extends Feature<Configuration> {
    public SedimentLayerFeature(Codec<Configuration> configCodec) {
        super(configCodec);
    }

    public boolean m_142674_(FeaturePlaceContext<Configuration> context) {
        Configuration config = (Configuration)context.m_159778_();
        BlockPos origin = context.m_159777_();
        WorldGenLevel level = context.m_159774_();
        Random random = context.m_159776_();
        BlockState state = config.state();
        RuleTest target = config.target();
        int thickness = config.thickness().m_142270_(random);
        double tilt = Math.toRadians(config.tiltDegrees().m_142269_(random));
        double tiltDirection = Math.toRadians(360.0f * random.nextFloat());
        int radiusX = config.radius().m_142270_(random);
        int radiusZ = config.radius().m_142270_(random);
        if (thickness <= 0 || radiusX <= 0 || radiusZ <= 0) {
            return false;
        }
        double slope = Math.tan(tilt);
        double slopeX = Math.cos(tiltDirection) * slope;
        double slopeZ = Math.sin(tiltDirection) * slope;
        boolean generated = false;
        for (int x = -radiusX; x < radiusX; ++x) {
            float dx = (float)x / (float)radiusX;
            for (int z = -radiusZ; z < radiusZ; ++z) {
                if (!SedimentLayerFeature.isInSquircle(x, z, radiusX, radiusZ, 4.0f)) continue;
                float dz = (float)z / (float)radiusZ;
                double y = (double)x * slopeX + (double)z * slopeZ;
                float linearDistanceToCenter = 1.0f - Math.max(Math.abs(dx), Math.abs(dz));
                int localThickness = (int)Math.ceil((double)thickness * Math.sqrt(linearDistanceToCenter));
                for (int yOff = 0; yOff < localThickness; ++yOff) {
                    BlockPos pos = origin.m_142022_((double)x, y + (double)yOff, (double)z);
                    BlockState currentState = level.m_8055_(pos);
                    if (!target.m_7715_(currentState, random)) continue;
                    generated = true;
                    level.m_7731_(pos, state, 2);
                }
            }
        }
        return generated;
    }

    private static boolean isInSquircle(float x, float y, float width, float height, float pinchFactor) {
        double sdf = Math.pow(x / width, pinchFactor) + Math.pow(y / height, pinchFactor);
        return sdf <= 1.0;
    }

    public record Configuration(BlockState state, IntProvider thickness, IntProvider radius, FloatProvider tiltDegrees, RuleTest target) implements FeatureConfiguration
    {
        public static final Codec<Configuration> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)BlockState.f_61039_.fieldOf("state").forGetter(Configuration::state), (App)IntProvider.m_146545_((int)1, (int)32).fieldOf("thickness").forGetter(Configuration::thickness), (App)IntProvider.m_146545_((int)1, (int)32).fieldOf("radius").forGetter(Configuration::radius), (App)FloatProvider.m_146505_((float)0.0f, (float)90.0f).fieldOf("tilt_degrees").forGetter(Configuration::tiltDegrees), (App)RuleTest.f_74307_.fieldOf("target").forGetter(Configuration::target)).apply((Applicative)builder, Configuration::new));
    }
}

